#![allow(unknown_lints)]
#![allow(clippy::all)]
#![allow(
    missing_debug_implementations,
    missing_copy_implementations,
    trivial_casts,
    trivial_numeric_casts,
    unsafe_code,
    unstable_features,
    unused_import_braces,
    unused_qualifications,
    unused_imports
)]
// This code was autogenerated with `dbus-codegen-rust -m None -c ffidisp`, see https://github.com/diwic/dbus-rs
use dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::ffidisp;

pub trait OrgMprisMediaPlayer2Playlists {
    fn activate_playlist(&self, playlist_id: dbus::Path) -> Result<(), dbus::Error>;
    fn get_playlists(
        &self,
        index: u32,
        max_count: u32,
        order: &str,
        reverse_order: bool,
    ) -> Result<Vec<(dbus::Path<'static>, String, String)>, dbus::Error>;
    fn playlist_count(&self) -> Result<u32, dbus::Error>;
    fn orderings(&self) -> Result<Vec<String>, dbus::Error>;
    fn active_playlist(&self)
        -> Result<(bool, (dbus::Path<'static>, String, String)), dbus::Error>;
}

#[derive(Debug)]
pub struct OrgMprisMediaPlayer2PlaylistsPlaylistChanged {
    pub playlist: (dbus::Path<'static>, String, String),
}

impl arg::AppendAll for OrgMprisMediaPlayer2PlaylistsPlaylistChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.playlist, i);
    }
}

impl arg::ReadAll for OrgMprisMediaPlayer2PlaylistsPlaylistChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgMprisMediaPlayer2PlaylistsPlaylistChanged {
            playlist: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgMprisMediaPlayer2PlaylistsPlaylistChanged {
    const NAME: &'static str = "PlaylistChanged";
    const INTERFACE: &'static str = "org.mpris.MediaPlayer2.Playlists";
}

impl<'a, C: ::std::ops::Deref<Target = ffidisp::Connection>> OrgMprisMediaPlayer2Playlists
    for ffidisp::ConnPath<'a, C>
{
    fn activate_playlist(&self, playlist_id: dbus::Path) -> Result<(), dbus::Error> {
        self.method_call(
            "org.mpris.MediaPlayer2.Playlists",
            "ActivatePlaylist",
            (playlist_id,),
        )
    }

    fn get_playlists(
        &self,
        index: u32,
        max_count: u32,
        order: &str,
        reverse_order: bool,
    ) -> Result<Vec<(dbus::Path<'static>, String, String)>, dbus::Error> {
        self.method_call(
            "org.mpris.MediaPlayer2.Playlists",
            "GetPlaylists",
            (index, max_count, order, reverse_order),
        )
        .and_then(|r: (Vec<(dbus::Path<'static>, String, String)>,)| Ok(r.0))
    }

    fn playlist_count(&self) -> Result<u32, dbus::Error> {
        <Self as ffidisp::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.mpris.MediaPlayer2.Playlists",
            "PlaylistCount",
        )
    }

    fn orderings(&self) -> Result<Vec<String>, dbus::Error> {
        <Self as ffidisp::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.mpris.MediaPlayer2.Playlists",
            "Orderings",
        )
    }

    fn active_playlist(
        &self,
    ) -> Result<(bool, (dbus::Path<'static>, String, String)), dbus::Error> {
        <Self as ffidisp::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.mpris.MediaPlayer2.Playlists",
            "ActivePlaylist",
        )
    }
}
