% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace.R
\name{str_replace}
\alias{str_replace}
\alias{str_replace_all}
\title{Replace matches with new text}
\usage{
str_replace(string, pattern, replacement)

str_replace_all(string, pattern, replacement)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern to look for.

The default interpretation is a regular expression, as described
in \link[stringi:about_search_regex]{stringi::about_search_regex}. Control options with
\code{\link[=regex]{regex()}}.

For \code{str_replace_all()} this can also be a named vector
(\code{c(pattern1 = replacement1)}), in order to perform multiple replacements
in each element of \code{string}.

Match a fixed string (i.e. by comparing only bytes), using
\code{\link[=fixed]{fixed()}}. This is fast, but approximate. Generally,
for matching human text, you'll want \code{\link[=coll]{coll()}} which
respects character matching rules for the specified locale.

You can not match boundaries, including \code{""}, with this function.}

\item{replacement}{The replacement value, usually a single string,
but it can be the a vector the same length as \code{string} or \code{pattern}.
References of the form \verb{\\1}, \verb{\\2}, etc will be replaced with
the contents of the respective matched group (created by \verb{()}).

Alternatively, supply a function (or formula): it will be passed a single
character vector and should return a character vector of the same length.

To replace the complete string with \code{NA}, use
\code{replacement = NA_character_}.}
}
\value{
A character vector the same length as
\code{string}/\code{pattern}/\code{replacement}.
}
\description{
\code{str_replace()} replaces the first match; \code{str_replace_all()} replaces
all matches.
}
\examples{
fruits <- c("one apple", "two pears", "three bananas")
str_replace(fruits, "[aeiou]", "-")
str_replace_all(fruits, "[aeiou]", "-")
str_replace_all(fruits, "[aeiou]", toupper)
str_replace_all(fruits, "b", NA_character_)

str_replace(fruits, "([aeiou])", "")
str_replace(fruits, "([aeiou])", "\\\\1\\\\1")

# Note that str_replace() is vectorised along text, pattern, and replacement
str_replace(fruits, "[aeiou]", c("1", "2", "3"))
str_replace(fruits, c("a", "e", "i"), "-")

# If you want to apply multiple patterns and replacements to the same
# string, pass a named vector to pattern.
fruits \%>\%
  str_c(collapse = "---") \%>\%
  str_replace_all(c("one" = "1", "two" = "2", "three" = "3"))

# Use a function for more sophisticated replacement. This example
# replaces colour names with their hex values.
colours <- str_c("\\\\b", colors(), "\\\\b", collapse="|")
col2hex <- function(col) {
  rgb <- col2rgb(col)
  rgb(rgb["red", ], rgb["green", ], rgb["blue", ], maxColorValue = 255)
}

x <- c(
  "Roses are red, violets are blue",
  "My favourite colour is green"
)
str_replace_all(x, colours, col2hex)
}
\seealso{
\code{\link[=str_replace_na]{str_replace_na()}} to turn missing values into "NA";
\code{\link[stringi:stri_replace]{stringi::stri_replace()}} for the underlying implementation.
}
