% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vulns.R
\name{vulns}
\alias{vulns}
\title{Request Vulnerability Information for a Package}
\usage{
vulns(
  packages = NULL,
  lockfile = NULL,
  ...,
  repos = NULL,
  verbose = FALSE,
  project = NULL
)
}
\arguments{
\item{packages}{A vector of package specifications, of the form
\verb{<package>==<version>} or \verb{<package>@<version>}.}

\item{lockfile}{The path to an \code{renv} lockfile. When specified, \code{packages}
is ignored, and vulnerabilities are queried based on the packages defined
in the lockfile.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, renv will signal an error.}

\item{repos}{The Package Manager repository to be queried.}

\item{verbose}{Boolean; when \code{TRUE}, verbose information from the \code{curl}
web request will be printed to the console.}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
An \R list of vulnerability information. Only packages which
have known vulnerabilities will be included in the resulting data object.
}
\description{
This function acts as an interface to Posit Package Manager's vulnerability
API, making it possible to ascertain if the provided packages have any
known vulnerabilities.
}
\details{
This function requires the \pkg{curl} package to be installed.
}
\keyword{internal}
