% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxPenalty.R
\name{mxPenalty}
\alias{mxPenalty}
\title{This function creates a penalty object}
\usage{
mxPenalty(
  what,
  epsilon = 1e-05,
  scale = 1,
  how = imxPenaltyTypes,
  smoothProportion = 0.05,
  hyperparams = c(),
  hpranges = list(),
  name = NULL
)
}
\arguments{
\item{what}{A character vector of parameters to regularize}

\item{epsilon}{how close to zero is zero?}

\item{scale}{a given parameter is divided by \code{scale} before comparison with \code{epsilon}}

\item{how}{what kind of function to use}

\item{smoothProportion}{what proportion of the region between \code{epsilon} and zero should be used to smooth the penalty function}

\item{hyperparams}{a character vector of hyperparameter names}

\item{hpranges}{a named list of hyperparameter ranges. Used in search if no ranges are specified.}

\item{name}{Name of the regularizer object}
}
\description{
This function creates a penalty object
}
\details{
\code{mxPenalty} expects to find an \link{mxMatrix} with
  free parameters that correspond to all named hyperparameters.

Gradient descent optimizers are designed for and work best on
smooth functions.  All of the regularization penalties implemented
traditionally contain discontinuities.  By default, OpenMx uses
smoothed versions of these functions. Smoothing is controlled by
\code{smoothProportion}. If \code{smoothProportion} is zero then
the traditional discontinuous functions are used. Otherwise,
\code{smoothProportion} of the region between \code{epsilon} and
zero is used for smoothing.
}
