#define XERR "memoryaccess"
#include "memoryaccess.ih"

    // by memorybridge/info.cc

void MemoryAccess::info(ostream &out) const
{
    out <<  "MemoryAccess ID: " << d_id << "\n"
            "maximum size: " << d_maxEnd << "\n"
            "# blocks: " << d_nBlocks << "\n"
            "block size: " << d_blockSize << '\n';

    size_t idx;
    for (idx = 0; idx != d_nBlocks; ++idx)      // find the 1st block idx
    {
        if (d_block[idx] != -1)
            break;
    }
    
    if (idx == d_nBlocks)
        cout << "no connected data blocks\n";
    else
    {
        for (idx = 0; idx != d_nBlocks; ++idx)      // details of known blocks
        {
            if (int id = d_block[idx]; id != -1)
            {
                size_t offset = idx * d_blockSize;
                cout << "data block " << idx << ": id = " << id << 
                        " (offsets: " << offset << " to " <<
                                         (offset + d_blockSize) << ")\n";
            }
        }
    }
}




