; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId=4DA2F2FC-AD2D-414A-8197-0DD52F1593D2
AppName=atomes
AppVerName=atomes 1.2.1
AppPublisher=CNRS
AppPublisherURL=https://atomes.ipcms.fr/
AppSupportURL=https://atomes.ipcms.fr/
AppUpdatesURL=https://atomes.ipcms.fr/
DefaultDirName={autopf}\atomes
DisableDirPage=yes
DefaultGroupName=atomes
LicenseFile=COPYING
OutputDir=Setup
OutputBaseFilename=atomes-latest-setup
SetupIconFile=setup.ico
UninstallDisplayIcon=setup.ico
Compression=lzma2
SolidCompression=yes
ChangesAssociations=yes
; "ArchitecturesAllowed=x64" specifies that Setup cannot run on
; anything but x64.
ArchitecturesAllowed=x64
; "ArchitecturesInstallIn64BitMode=x64" requests that the install be
; done in "64-bit mode" on x64, meaning it should use the native
; 64-bit Program Files directory and the 64-bit view of the registry.
ArchitecturesInstallIn64BitMode=x64
WizardStyle=modern

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Code]
[Code]
var
    maj : Integer;
    min : Integer;
    patch : Integer;
    version : String;
    key : String;
    
function InitializeSetup(): Boolean;
begin
  Result := TRUE;
  maj := 1;
  min := 1;
  patch := 0;
  while (maj <= 1) do
  begin
    while (min <= 2) do
    begin
      while (patch <= 18) do
      begin
        version := IntToStr(maj) + '.' + IntToStr(min) + '.' + IntToStr(patch);
        key := 'Software\IPCMS\ATOMES\' + version;
        if RegValueExists(HKEY_LOCAL_MACHINE, key, 'Version') then
        begin
          MsgBox(Format('An older version of atomes has been detected on your computer: %s'#13#13'Please uninstall this previous version before installing any other', [version]), mbConfirmation, MB_OK);
          Result := FALSE;
        end;
        patch := patch + 1;
      end;
      min := min + 1;
    end;
    maj := maj + 1;
  end;
end;

[Registry]
Root: HKLM; Subkey: "Software\IPCMS\ATOMES"; Flags: uninsdeletekeyifempty
Root: HKLM; Subkey: "Software\IPCMS\ATOMES\1.2.1"; Flags: uninsdeletekey
Root: HKLM; Subkey: "Software\IPCMS\ATOMES\1.2.1"; ValueType: string; ValueName: "Path"; ValueData: "{app}"; Flags: uninsdeletekey
Root: HKLM; Subkey: "Software\IPCMS\ATOMES\1.2.1"; ValueType: string; ValueName: "Version"; ValueData: "1.2.1"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\IPCMS\ATOMES"; Flags: uninsdeletekeyifempty
Root: HKA; Subkey: "Software\IPCMS\ATOMES\1.2.1"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\IPCMS\ATOMES\1.2.1"; ValueType: string; ValueName: "Path"; ValueData: "{app}"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\IPCMS\ATOMES\1.2.1"; ValueType: string; ValueName: "Version"; ValueData: "1.2.1"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\IPCMS\ATOMES\1.2.1"; ValueType: string; ValueName: "Name"; ValueData: "atomes"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\IPCMS\ATOMES\1.2.1"; ValueType: string; ValueName: "Company"; ValueData: "Institut de Physique et Chimie des Matériaux de Strasbourg"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\.awf\OpenWithProgids"; ValueType: string; ValueName: "atomesWorkspaceFile.awf"; ValueData: ""; Flags: uninsdeletevalue
Root: HKA; Subkey: "Software\Classes\atomesWorkspaceFile.awf"; ValueType: string; ValueName: ""; ValueData: "atomes Workspace File"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesWorkspaceFile.awf\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "atomes-workspace.ico"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesWorkspaceFile.awf\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\atomes.exe"" ""%1"""
Root: HKA; Subkey: "Software\Classes\Applications\atomes.exe\SupportedTypes"; ValueType: string; ValueName: ".awf"; ValueData: ""; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\.apf\OpenWithProgids"; ValueType: string; ValueName: "atomesProjectFile.apf"; ValueData: ""; Flags: uninsdeletevalue
Root: HKA; Subkey: "Software\Classes\atomesProjectFile.awf"; ValueType: string; ValueName: ""; ValueData: "atomes Project File"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesProjectFile.apf\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "atomes-project.ico"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesProjectFile.apf\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\atomes.exe"" ""%1"""
Root: HKA; Subkey: "Software\Classes\Applications\atomes.exe\SupportedTypes"; ValueType: string; ValueName: ".apf"; ValueData: ""; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\.xyz\OpenWithProgids"; ValueType: string; ValueName: "atomesAtomicCoord-XYZ"; ValueData: ""; Flags: uninsdeletevalue
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-XYZ"; ValueType: string; ValueName: ""; ValueData: "XYZ Atomic Coordinates"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-XYZ\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "atomes-coordinates.ico"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-XYZ\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\atomes.exe"" ""%1"""
Root: HKA; Subkey: "Software\Classes\Applications\atomes.exe\SupportedTypes"; ValueType: string; ValueName: ".xyz"; ValueData: ""; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\.pdb\OpenWithProgids"; ValueType: string; ValueName: "atomesAtomicCoord-PDB"; ValueData: ""; Flags: uninsdeletevalue
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-PDB"; ValueType: string; ValueName: ""; ValueData: "PDB Atomic Coordinates"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-PDB\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "atomes-coordinates.ico"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-PDB\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\atomes.exe"" ""%1"""
Root: HKA; Subkey: "Software\Classes\Applications\atomes.exe\SupportedTypes"; ValueType: string; ValueName: ".pdb"; ValueData: ""; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\.ent\OpenWithProgids"; ValueType: string; ValueName: "atomesAtomicCoord-ENT"; ValueData: ""; Flags: uninsdeletevalue
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-ENT"; ValueType: string; ValueName: ""; ValueData: "ENT Atomic Coordinates"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-ENT\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "atomes-coordinates.ico"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-ENT\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\atomes.exe"" ""%1"""
Root: HKA; Subkey: "Software\Classes\Applications\atomes.exe\SupportedTypes"; ValueType: string; ValueName: ".ent"; ValueData: ""; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\.cif\OpenWithProgids"; ValueType: string; ValueName: "atomesAtomicCoord-CIF"; ValueData: ""; Flags: uninsdeletevalue
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-CIF"; ValueType: string; ValueName: ""; ValueData: "CIF crystallographic information"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-CIF\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "atomes-coordinates.ico"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-CIF\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\atomes.exe"" ""%1"""
Root: HKA; Subkey: "Software\Classes\Applications\atomes.exe\SupportedTypes"; ValueType: string; ValueName: ".cif"; ValueData: ""; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\.trj\OpenWithProgids"; ValueType: string; ValueName: "atomesAtomicCoord-TRJ"; ValueData: ""; Flags: uninsdeletevalue
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-TRJ"; ValueType: string; ValueName: ""; ValueData: "CPMD trajectory"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-TRJ\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "atomes-coordinates.ico"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-TRJ\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\atomes.exe"" ""%1"""
Root: HKA; Subkey: "Software\Classes\Applications\atomes.exe\SupportedTypes"; ValueType: string; ValueName: ".trj"; ValueData: ""; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\.xdatcar\OpenWithProgids"; ValueType: string; ValueName: "atomesAtomicCoord-VAS"; ValueData: ""; Flags: uninsdeletevalue
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-VAS"; ValueType: string; ValueName: ""; ValueData: "VASP trajectory"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-VAS\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "atomes-coordinates.ico"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-VAS\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\atomes.exe"" ""%1"""
Root: HKA; Subkey: "Software\Classes\Applications\atomes.exe\SupportedTypes"; ValueType: string; ValueName: ".xdatcar"; ValueData: ""; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\.c3d\OpenWithProgids"; ValueType: string; ValueName: "atomesAtomicCoord-C3D"; ValueData: ""; Flags: uninsdeletevalue
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-C3D"; ValueType: string; ValueName: ""; ValueData: "Chem3D Atomic Coordinates"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-C3D\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "atomes-coordinates.ico"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-C3D\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\atomes.exe"" ""%1"""
Root: HKA; Subkey: "Software\Classes\Applications\atomes.exe\SupportedTypes"; ValueType: string; ValueName: ".c3d"; ValueData: ""; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\.hist\OpenWithProgids"; ValueType: string; ValueName: "atomesAtomicCoord-HIST"; ValueData: ""; Flags: uninsdeletevalue
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-HIST"; ValueType: string; ValueName: ""; ValueData: "DL-POLY History File"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-HIST\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "atomes-coordinates.ico"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\atomesAtomicCoord-HIST\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\atomes.exe"" ""%1"""
Root: HKA; Subkey: "Software\Classes\Applications\atomes.exe\SupportedTypes"; ValueType: string; ValueName: ".hist"; ValueData: ""; Flags: uninsdeletekey
Root: HKLM; SubKey: "SYSTEM\CurrentControlSet\Control\Session Manager\Environment\"; ValueType: string; ValueName: "Path"; ValueData: "{reg:HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment\,Path};{app}"

[Code]
procedure CurUninstallStepChanged(CurUninstallStep: TUninstallStep);
var
  Path, AppDir: string;
  Index: Integer;
begin
  if CurUninstallStep = usUninstall then
  begin
    if RegQueryStringValue(HKEY_LOCAL_MACHINE,
      'SYSTEM\CurrentControlSet\Control\Session Manager\Environment\',
      'Path', Path) then
    begin
      AppDir := ExpandConstant('{app}');
      Index := Pos(AppDir, Path);
      Delete(Path, Index-1, Length(AppDir)+1);
      RegWriteStringValue(HKEY_LOCAL_MACHINE,
        'SYSTEM\CurrentControlSet\Control\Session Manager\Environment\',
        'Path', Path);
    end;
  end;
end;

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Components: main; Flags: unchecked
; Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Components: main; Flags: unchecked

[Files]
Source: "atomes\pixmaps\*"; DestDir: "{app}\pixmaps\"; Components: main; Flags: ignoreversion recursesubdirs createallsubdirs
Source: "atomes\library\*"; DestDir: "{app}\library"; Components: main; Flags: ignoreversion recursesubdirs createallsubdirs
Source: "atomes\bin\*"; DestDir: "{app}\bin\"; Components: main; Flags: ignoreversion
Source: "atomes\etc\*"; DestDir: "{app}\etc\"; Components: main; Flags: ignoreversion recursesubdirs createallsubdirs
Source: "atomes\lib\*"; DestDir: "{app}\lib\"; Components: main; Flags: ignoreversion recursesubdirs createallsubdirs
Source: "atomes\share\*"; DestDir: "{app}\share\"; Components: main; Flags: ignoreversion recursesubdirs createallsubdirs
Source: "atomes\var\*";  DestDir: "{app}\var\"; Components: main; Flags: ignoreversion recursesubdirs createallsubdirs
Source: "atomes.ico"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "setup.ico"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "atomes-workspace.ico"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "atomes-project.ico"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "atomes-coordinates.ico"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "COPYING"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "ChangeLog"; DestDir: "{app}"; Components: main; Flags: ignoreversion
Source: "gtk-sources\*";  DestDir: "{app}\gtk-sources\"; Components: main; Flags: ignoreversion

; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Icons]
Name: "{group}\atomes"; Filename: "{app}\bin\atomes.exe"; WorkingDir: "{app}"; IconFilename: "{app}\atomes.ico"; Components: main
Name: "{group}\{cm:ProgramOnTheWeb,atomes}"; Filename: "https://atomes.ipcms.fr/"; Components: main;
Name: "{group}\{cm:UninstallProgram,atomes}"; Filename: "{uninstallexe}"; IconFilename: "{app}\atomes.ico"; Components: main;
Name: "{commondesktop}\atomes"; Filename: "{app}\bin\atomes.exe"; Tasks: desktopicon; WorkingDir: "{app}"; IconFilename: "{app}\atomes.ico"; Components: main
; Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\Atomes"; Filename: "{app}\bin\atomes.exe"; WorkingDir: "{app}"; Tasks: quicklaunchicon; IconFilename: "{app}\atomes.ico"; Components: main

[Components]
Name: "main"; Description: "atomes"; Types: full compact custom   

[Run]
Filename: "{app}\bin\atomes.exe"; Description: "{cm:LaunchProgram,Atomes}"; Flags: nowait postinstall skipifsilent

